#include "stdafx.h"
#include "LF C DEMO.h"
#include "DlgScan.h"

#include "LF_ID_C_API.h"


IMPLEMENT_DYNAMIC(CDlgScan, CPropertyPage)

CDlgScan::CDlgScan()
	: CPropertyPage(CDlgScan::IDD)
{

}

CDlgScan::~CDlgScan()
{
}

void CDlgScan::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST_SCAN, m_ctrlCard);
}


BEGIN_MESSAGE_MAP(CDlgScan, CPropertyPage)
	ON_BN_CLICKED(IDC_BTN_SCAN, &CDlgScan::OnBnClickedBtnScan)
END_MESSAGE_MAP()

BOOL CDlgScan::OnInitDialog()
{
	CPropertyPage::OnInitDialog();

	InsertColumn(0, _T("Card type"),		80	);
	InsertColumn(1, _T("Card id"),			120	);

	return TRUE;
}

void CDlgScan::InsertColumn(UINT nCol, TCHAR* szData, UINT nMaxLen)
{
	if(szData != NULL)
	{
		LV_COLUMN stLvc;
		stLvc.mask		= LVCF_FMT | LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
		stLvc.iSubItem	= nCol;
		stLvc.pszText	= szData;
		stLvc.cx		= nMaxLen;
		stLvc.fmt		= LVCFMT_LEFT;
		m_ctrlCard.InsertColumn(nCol, &stLvc);
		// m_ctrlData.SetColumnWidth( nCol, LVSCW_AUTOSIZE_USEHEADER);
	}
}

void CDlgScan::InsertItem(UINT nIntem, UINT nSubItem, TCHAR* szString, UINT nImage)
{
	LVITEM stLvItem;
	::ZeroMemory(&stLvItem, sizeof(LVITEM));

	stLvItem.iItem = nIntem;
	stLvItem.iSubItem = nSubItem;
	stLvItem.mask = LVIF_TEXT | LVIF_STATE;
	if(nImage != -1)
	{
		stLvItem.mask |= LVIF_IMAGE;
		stLvItem.iImage	 = nImage;
	}
	stLvItem.pszText = szString;
	stLvItem.cchTextMax = (int)_tcslen(szString) + 1;

	if(nSubItem == 0x00)
	{
		// set the default count to 1 - in item data
		//
		m_ctrlCard.InsertItem(&stLvItem);
	}

	if(nSubItem > 0x00)
		m_ctrlCard.SetItem(&stLvItem);
}

void CDlgScan::OnBnClickedBtnScan()
{
	m_ctrlCard.DeleteAllItems();
	SDKHANDLE hReader = OpenReader(m_rfidDriver.ComPort());
	if(hReader != NULL)
	{
		BYTE pBufTmp[MAX_PATH]; UINT nSize = MAX_PATH;
		if(GetCardID(hReader, pBufTmp, nSize) == ER_OK)
		{
			CString strType = _T("Unknown");
			switch(pBufTmp[0x00])
			{
				case 'h': strType = _T("Hitag1");	break;
				case 'H': strType = _T("Hitag2");	break;
				case 'Q': strType = _T("Q5");		break;
				case 'U': strType = _T("EM42XX");	break;
				case 'T': strType = _T("Titan");	break;
				case 'M': strType = _T("Temic");	break;
				case 'Z': strType = _T("ISO FDX");	break;
			}

			USES_CONVERSION;
			InsertItem(0, 0, (TCHAR*)(LPCTSTR)strType, -1);
			InsertItem(0, 1, A2T((CHAR*)pBufTmp + 0x01), -1);
		}

		CloseReader(hReader);
	}
}
